<%@ Import Namespace="System.Data"%>
<%@ Import Namespace="System.Data.OleDb"%>
<%@ Import Namespace="Excel"%>
<%@ Import Namespace="System.IO"%>
<%@ Page Language="VB" %>
<script runat="server">
    Sub Page_Load(sender As Object, e As EventArgs)		
		Dim objConn As New OleDbConnection
        Dim dtAdapter As OleDbDataAdapter
        Dim dt As New System.Data.DataTable

        Dim strConnString As String
        strConnString = "Provider=Microsoft.Jet.OLEDB.4.0;Data Source=" & Server.MapPath("database/mydatabase.mdb") & ";"
        objConn = New OleDbConnection(strConnString)
        objConn.Open()

        Dim strSQL As String
        strSQL = "SELECT * FROM customer"

        '*** Create DataTable ***'	
        dtAdapter = New OleDbDataAdapter(strSQL, objConn)
        dtAdapter.Fill(dt)

        '*** Export To Excel ***'
        Dim FileName As String = "MyXls/MyExcel.xls"

        '*** Create Exce.Application ***'
        Dim xlApp As New Excel.Application
        Dim xlSheet As Excel.Worksheet
        Dim xlBook As Excel.Workbook
        Dim i, intStartRows, intEndRows As Integer


        xlBook = xlApp.Workbooks.Add()
        xlSheet = xlBook.Worksheets(1)

        xlBook.Application.Visible = False

        xlBook.Sheets.Add()
        xlBook.ActiveSheet.Name = "Customer"

        With xlBook.Sheets("Customer").Cells(1, 1)
            .Value = "My Customer"
            .Font.Bold = True
            .Font.Name = "Tahoma"
            .Font.Size = 16
        End With

        With xlBook.Sheets("Customer").Cells(2, 1)
            .Value = "Customer Name"
            .Font.Name = "Tahoma"
            .BORDERS.Weight = 1
            .Font.Size = 10
            .MergeCells = True
        End With

        With xlBook.Sheets("Customer").Cells(2, 2)
            .Value = "Used"
            .BORDERS.Weight = 1
            .Font.Name = "Tahoma"
            .Font.Size = 10
            .MergeCells = True
        End With

        intStartRows = 3
        intEndRows = intStartRows + dt.Rows.Count - 1
        For i = 0 To dt.Rows.Count - 1
            xlBook.Sheets("Customer").Cells(intStartRows + i, 1).Value = dt.Rows(i)("Name")
            xlBook.Sheets("Customer").Cells(intStartRows + i, 2).Value = dt.Rows(i)("Used")
            xlBook.Sheets("Customer").Cells(intStartRows + i, 2).NumberFormat = "$#,##0.00"
        Next

        '*** Creating Chart ***'
        xlBook.Charts.Add()
        xlBook.ActiveChart.Name = "ExcelGraph"
        xlBook.Charts("ExcelGraph").SetSourceData(xlBook.Sheets("Customer").Range("A" & intStartRows & ":B" & intEndRows & ""))

        '*** Chart 3D Columns ***'
        With xlBook.Charts("ExcelGraph")
            .ChartType = 54
            .PlotBy = 1
            .HasAxis(1) = 0
        End With

        '*** If Files Already Exist Delete files ***'
		Dim MyFile As New FileInfo(Server.MapPath(FileName))
		If MyFile.Exists Then
			MyFile.Delete()
		End IF
		MyFile = Nothing

        '*** Save Excel ***'
        'xlSheet.PrintOut 1 '*** Print to printer ***'
        xlSheet.SaveAs(Server.MapPath(FileName))
        xlApp.Quit()

        '*** Quit and Clear Object ***'
        xlSheet = Nothing
        xlBook = Nothing
        xlApp = Nothing

        '*** End Export To Excel ***'

        Me.lblText.Text = "Charts Created <a href=" & FileName & ">Click here</a> to Download."

        dtAdapter = Nothing
        objConn.Close()
        objConn = Nothing

	End Sub
</script>
<html>
<head>
    <title>ShotDev.Com Tutorial</title>
</head>
<body>
	<form id="form1" runat="server">	
	<asp:Label id="lblText" runat="server"></asp:Label>
	</form>
</body>
</html>
<!--- This file download from www.shotdev.com -->