<%@ Import Namespace="System.Data"%>
<%@ Import Namespace="System.Data.OleDb"%>
<%@ Import Namespace="Excel"%>
<%@ Import Namespace="System.IO"%>
<%@ Page Language="VB" %>
<script runat="server">
    Sub Page_Load(sender As Object, e As EventArgs)		

        Dim objConn As New OleDbConnection
        Dim dtAdapter As OleDbDataAdapter
        Dim dt As New System.Data.DataTable

        Dim strConnString As String
        strConnString = "Provider=Microsoft.Jet.OLEDB.4.0;Data Source=" & Server.MapPath("database/mydatabase.mdb") & ";"
        objConn = New OleDbConnection(strConnString)
        objConn.Open()

        Dim strSQL As String
        strSQL = "SELECT * FROM customer"

        '*** Create DataTable ***'	
        dtAdapter = New OleDbDataAdapter(strSQL, objConn)
        dtAdapter.Fill(dt)

        '*** Export To Excel ***'
        Dim FileNameXls,FileNameImg,Ext As String
        FileNameXls = "MyXls/MyExcel.xls"

		'*** File Name Gif,Jpeg,... ***'
		FileNameImg = "MyXls/MyCharts.Gif" '*** MyXls/MyChart.Jpg ***'
		Ext = "Gif" '*** Jpeg ***'

        '*** Create Exce.Application ***'
        Dim xlApp As New Excel.Application
        Dim xlSheet As Excel.Worksheet
        Dim xlBook As Excel.Workbook
        Dim i, intStartRows, intEndRows As Integer

        xlBook = xlApp.Workbooks.Add()
        xlSheet = xlBook.Worksheets(1)

        xlApp.Application.Visible = False

        '*** Delete Sheet (2,3) - Sheet Default ***'
        xlBook.Worksheets(2).Select()
        xlBook.Worksheets(2).Delete()
        xlBook.Worksheets(2).Select()
        xlBook.Worksheets(2).Delete()

        '*** Sheet Data Rows ***'
        xlBook.Worksheets(1).Name = "MyReport"
        xlBook.Worksheets(1).Select()

        With xlBook.ActiveSheet.Cells(1, 1)
            .Value = "My Customer"
            .Font.Bold = True
            .Font.Name = "Tahoma"
            .Font.Size = 16
        End With

        With xlBook.ActiveSheet.Cells(2, 1)
            .Value = "Customer Name"
            .Font.Name = "Tahoma"
            .BORDERS.Weight = 1
            .Font.Size = 10
            .MergeCells = True
        End With

        With xlBook.ActiveSheet.Cells(2, 2)
            .Value = "Used"
            .BORDERS.Weight = 1
            .Font.Name = "Tahoma"
            .Font.Size = 10
            .MergeCells = True
        End With

        intStartRows = 3
        intEndRows = intStartRows + dt.Rows.Count - 1
        For i = 0 To dt.Rows.Count - 1
            xlBook.ActiveSheet.Cells(intStartRows + i, 1).Value = dt.Rows(i)("Name")
            xlBook.ActiveSheet.Cells(intStartRows + i, 2).Value = dt.Rows(i)("Used")
            xlBook.ActiveSheet.Cells(intStartRows + i, 2).NumberFormat = "$#,##0.00"
        Next

        '*** Creating Chart ***'
        xlBook.Charts.Add()
        xlBook.ActiveChart.ChartType = 54
        xlBook.ActiveChart.SetSourceData(xlBook.Sheets("MyReport").Range("A" & intStartRows & ":B" & intEndRows & ""))
        'xlBook.ActiveChart.SeriesCollection(1).Name = "Series1"
        'xlBook.ActiveChart.SeriesCollection(2).Name = "Series1"
        xlBook.ActiveChart.Location(2, "MyReport")

        '*** Sheet Properties ***'
        With xlBook.ActiveChart
            .HasTitle = True
            '.PlotBy = 1
            .HasAxis(1) = 1
            .ChartTitle.Text = "Customer Report"
            .ChartTitle.Characters.Text = "Customer Report"
            .ChartTitle.Font.Name = "Tahoma"
            .ChartTitle.Font.FontStyle = "Bold"
            .ChartTitle.Font.Size = 20
            .ChartTitle.Font.ColorIndex = 3
            '.Axes(1, 1).HasTitle = True
            '.Axes(1, 1).AxisTitle.Characters.Text = "X"
            '.Axes(2, 1).HasTitle = True
            '.Axes(2, 1).AxisTitle.Characters.Text = "Y"
            '.HasDataTable = False '*** DataTable (False/True) ***'
        End With

        '*** Set Area ***'
        xlBook.ActiveSheet.Shapes("Chart 1").IncrementLeft(20)
        xlBook.ActiveSheet.Shapes("Chart 1").IncrementTop(-97.5)


        '*** Set Height & Width ***'
        xlBook.ActiveSheet.Shapes("Chart 1").ScaleHeight(1.0, 0, 0)
        xlBook.ActiveSheet.Shapes("Chart 1").ScaleWidth(1.0, 0, 0)

        '*** If Files Already Exist Delete files ***'
		Dim MyFile As New FileInfo(Server.MapPath(FileNameXls))
		If MyFile.Exists Then
			MyFile.Delete()
		End IF
		MyFile = Nothing

        '*** Save Excel ***'
        'xlSheet.PrintOut 1 '*** Print to printer ***'
        xlSheet.SaveAs(Server.MapPath(FileNameXls))

		'*** Save To Gif,Jpeg ***'
		'xlApp.ActiveChart.Export "C:\Inetpub\wwwroot\dotnet\MyXls\MyChart.Gif","Gif"
		xlApp.ActiveChart.Export(Server.MapPath(FileNameImg),Ext)
		
		xlApp.Application.Quit()
        xlApp.Quit()

        '*** Quit and Clear Object ***'
        xlSheet = Nothing
        xlBook = Nothing
        xlApp = Nothing

        '*** End Export To Excel ***'
        Me.lblText.Text = "<img src=" & FileNameImg & ">"

        dtAdapter = Nothing
        objConn.Close()
        objConn = Nothing
	End Sub
</script>
<html>
<head>
    <title>ShotDev.Com Tutorial</title>
</head>
<body>
	<form id="form1" runat="server">	
	<asp:Label id="lblText" runat="server"></asp:Label>
	</form>
</body>
</html>
<!--- This file download from www.shotdev.com -->