<%@ Import Namespace="System.IO"%>
<%@ Import Namespace="Microsoft.Office.Interop.Excel"%>
<%@ Page Language="VB" %>
<script runat="server">
    Sub Page_Load(sender As Object, e As EventArgs)
		
        Dim FileName As String = "MyXls/MyExcel.xls"

		Const xlEdgeLeft = 7
		Const xlEdgeTop = 8
		Const xlEdgeBottom = 9
		Const xlEdgeRight = 10 

        '*** Create Excel.Application ***'
        Dim xlApp As New Microsoft.Office.Interop.Excel.Application
        Dim xlSheet1 As Microsoft.Office.Interop.Excel.Worksheet
        Dim xlBook As Microsoft.Office.Interop.Excel.Workbook

        xlBook = xlApp.Workbooks.Add()

		'*** Create Sheet 1 ***'
		xlSheet1 = xlBook.Worksheets(1)
		xlSheet1.Name = "My Sheet1"
		xlApp.Application.Visible = False

		'*** Write text to Row 1 Column 1 ***'
		With xlApp.ActiveSheet.Cells(1,1)
			.Value = "ShotDev.Com"
		End With

		'*** Write Cell Border ***'
		With xlApp.ActiveSheet.Range("B3:D5")
				.BORDERS().Weight = 2
		End With
		
		'*** MergeCells ***'
		With xlApp.ActiveSheet.Range("C3:D4")
				.MergeCells = True
				.BORDERS.Weight = 2
		End With

		'*** Write Cell Border & MergeCells ***'
		With xlApp.ActiveSheet.Range("B7:D9")
				.MergeCells = True
				.BORDERS(xlEdgeLeft).Weight = 2
				.BORDERS(xlEdgeTop).Weight = 2
				.BORDERS(xlEdgeBottom).Weight = 2
				.BORDERS(xlEdgeRight).Weight = 2
		End With

        '*** If Files Already Exist Delete files ***'
		Dim MyFile As New FileInfo(Server.MapPath(FileName))
		If MyFile.Exists Then
			MyFile.Delete()
		End IF
		MyFile = Nothing

        '*** Save Excel ***'
        'xlSheet1.PrintOut 1 '*** Print to printer ***'
        xlSheet1.SaveAs(Server.MapPath(FileName))
        xlApp.Application.Quit()
		xlApp.Quit()

        '*** Quit and Clear Object ***'
        xlSheet1 = Nothing
        xlBook = Nothing
        xlApp = Nothing

		Me.lblText.Text = "Excel Created <a href="& FileName & ">Click here</a> to Download."

	End Sub

</script>
<html>
<head>
    <title>ShotDev.Com Tutorial</title>
</head>
<body>
	<form id="form1" runat="server">
		<asp:Label id="lblText" runat="server"></asp:Label>
	</form>
</body>
</html>
<!--- This file download from www.shotdev.com -->