Imports Microsoft.Office.Interop.Word
Imports System.Data
Imports System.Data.OleDb
Public Class AspNetWordReport
    Inherits System.Web.UI.Page

    Protected Sub Page_Load(ByVal sender As Object, ByVal e As System.EventArgs) Handles Me.Load

        Const wdAlignParagraphCenter = 1
        Const wdAlignParagraphRight = 2

        Dim Wrd As New Microsoft.Office.Interop.Word.Application
        Dim WrdDoc As Microsoft.Office.Interop.Word.Document
        Dim MyRange1, MyRange2, MyRange3 As Microsoft.Office.Interop.Word.Range
        Dim objTable As Microsoft.Office.Interop.Word.Table
        Dim DocName As String = "MyDoc/MyWord.doc"
        Dim intRows As Integer
        Wrd.Application.Visible = False

        WrdDoc = Wrd.Documents.Open(Server.MapPath("shotdev.dot"))

        MyRange1 = WrdDoc.Paragraphs.Add.Range
        With MyRange1
            .ParagraphFormat.Alignment = wdAlignParagraphCenter
            .Font.Name = "Verdana"
            .Font.Size = "20"
            .Font.Bold = True
            .InsertBefore("Customer Report" & vbCrLf)
        End With

        '*** DataTable ***'
        Dim objConn As OleDbConnection
        Dim objCmd As OleDbCommand
        Dim dtAdapter As OleDbDataAdapter
        Dim dt As New DataTable
        Dim strConnString As String
        strConnString = "Provider=Microsoft.Jet.OLEDB.4.0;Data Source=" & Server.MapPath("database/mydatabase.mdb") & ";Jet OLEDB:Database Password=;"
        objConn = New OleDbConnection(strConnString)
        objConn.Open()

        Dim strSQL As String
        strSQL = "SELECT * FROM customer"
        dtAdapter = New OleDbDataAdapter(strSQL, objConn)
        dtAdapter.Fill(dt)
        dtAdapter = Nothing
        objConn.Close()
        objConn = Nothing
        '*** (End) DataTable ***'

        MyRange2 = WrdDoc.Paragraphs.Add.Range
        With MyRange2
            .Font.Size = "10"
        End With
        objTable = Wrd.ActiveDocument.Tables.Add(MyRange2, dt.Rows.Count, 6, 1, 2) '** Range,Rows,Column **'

        '*** Header ***'
        objTable.Cell(1, 1).Range.InsertAfter("CustomerID")
        objTable.Cell(1, 1).Range.Bold = True
        objTable.Cell(1, 1).Range.ParagraphFormat.Alignment = 1

        objTable.Cell(1, 2).Range.InsertAfter("Name")
        objTable.Cell(1, 2).Range.Bold = True
        objTable.Cell(1, 2).Range.ParagraphFormat.Alignment = 1

        objTable.Cell(1, 3).Range.InsertAfter("Email")
        objTable.Cell(1, 3).Range.Bold = True
        objTable.Cell(1, 3).Range.ParagraphFormat.Alignment = 1

        objTable.Cell(1, 4).Range.InsertAfter("CountryCode")
        objTable.Cell(1, 4).Range.Bold = True
        objTable.Cell(1, 4).Range.ParagraphFormat.Alignment = 1

        objTable.Cell(1, 5).Range.InsertAfter("Budget")
        objTable.Cell(1, 5).Range.Bold = True
        objTable.Cell(1, 5).Range.ParagraphFormat.Alignment = 1

        objTable.Cell(1, 6).Range.InsertAfter("Used")
        objTable.Cell(1, 6).Range.Bold = True
        objTable.Cell(1, 6).Range.ParagraphFormat.Alignment = 1

        '*** Detail ***
        For intRows = 0 To dt.Rows.Count - 1
            objTable.Cell(intRows + 2, 1).Range.InsertAfter(dt.Rows(intRows)("CustomerID"))
            objTable.Cell(intRows + 2, 1).Range.ParagraphFormat.Alignment = 1

            objTable.Cell(intRows + 2, 2).Range.InsertAfter(dt.Rows(intRows)("Name"))
            objTable.Cell(intRows + 2, 2).Range.ParagraphFormat.Alignment = 0

            objTable.Cell(intRows + 2, 3).Range.InsertAfter(dt.Rows(intRows)("Email"))
            objTable.Cell(intRows + 2, 3).Range.ParagraphFormat.Alignment = 0

            objTable.Cell(intRows + 2, 4).Range.InsertAfter(dt.Rows(intRows)("CountryCode"))
            objTable.Cell(intRows + 2, 4).Range.ParagraphFormat.Alignment = 1

            objTable.Cell(intRows + 2, 5).Range.InsertAfter(FormatNumber(dt.Rows(intRows)("Budget"), 2))
            objTable.Cell(intRows + 2, 5).Range.ParagraphFormat.Alignment = 2

            objTable.Cell(intRows + 2, 6).Range.InsertAfter(FormatNumber(dt.Rows(intRows)("Used"), 2))
            objTable.Cell(intRows + 2, 6).Range.ParagraphFormat.Alignment = 2
        Next


        MyRange3 = WrdDoc.Paragraphs.Add.Range
        With MyRange3
            .ParagraphFormat.Alignment = wdAlignParagraphRight
            .Font.Name = "Verdana"
            .Font.Size = "10"
            .InsertBefore(vbCrLf & vbCrLf & vbCrLf & "................................Manager" & vbCrLf & Now())
        End With

        WrdDoc.SaveAs(Server.MapPath(DocName))
        Wrd.Application.Quit()
        Wrd = Nothing

       

    End Sub
End Class
