<%@ Import Namespace="System.Drawing" %>
<%@ Import Namespace="System.Drawing.Imaging" %>
<%@ Import Namespace="System.IO"%>
<%@ Page Language="VB" %>
<script runat="server">

	Sub Page_Load(sender As Object, e As EventArgs)	
		If Not Page.IsPostBack() Then
			Me.txtFrom.Text = "Gallery/"
			Me.txtTo.Text = "Resize/"
		End IF
	End Sub

    Sub btnCreate_OnClick(sender As Object, e As EventArgs)

		Dim myDirInfo As DirectoryInfo
		Dim arrFileInfo As Array
		Dim myFileInfo As FileInfo
		Dim FileName As String
		Dim NewFileName As String

		Me.lblText.Text = ""

		myDirInfo = New DirectoryInfo(Server.MapPath(Me.txtFrom.Text))		
		arrFileInfo = myDirInfo.GetFiles("*.jpg")
		For Each myFileInfo In arrFileInfo
			FileName = txtFrom.Text & myFileInfo.Name
			NewFileName = txtTo.Text & "Thumbnail_"&myFileInfo.Name
			
			'*** Call to function resize ***'
			Call ResizeImages(FileName,NewFileName)

			Me.lblText.Text = Me.lblText.Text & (FileName & "===> <a href=" & NewFileName & ">" & NewFileName &"</a><br>")
		Next myFileInfo

	End Sub

	Sub ResizeImages(FileName,NewFileName)	
		Dim intWidth,intHeight As Integer

		intWidth = 	100 '*** Fix Width ***'
		intHeight = 0   '*** If = 0 Auto Re-Cal Size ***'

		Dim objGraphic As System.Drawing.Image = System.Drawing.Image.FromFile(Server.MapPath(FileName))

		Dim objBitmap As Bitmap
		'*** Calculate Height ***'
		If intHeight > 0 Then
			objBitmap = New Bitmap(objGraphic, intWidth, intHeight)
		Else
			If objGraphic.Width > intWidth Then
				Dim ratio As Double = objGraphic.Height / objGraphic.Width
				intHeight = ratio * intWidth
				objBitmap = New Bitmap(objGraphic, intWidth, intHeight)
			Else
				objBitmap = New Bitmap(objGraphic)
			End If
		End If
		
		'*** Save As  ***'
		objBitmap.Save(Server.MapPath(NewFileName), objGraphic.RawFormat) 
		
		'*** Close ***'
		objGraphic.Dispose()
		
		'*** Nothing ***'
		objBitmap = Nothing
		objGraphic = Nothing
		
	End Sub

</script>
<html>
<head>
    <title>ShotDev.Com Tutorial</title>
</head>
<body>
	<form id="form1" runat="server">
		<asp:Label id="lblForm" runat="server" Text="Path From" Width="58px"></asp:Label>
		<asp:Textbox id="txtFrom" runat="server"></asp:Textbox><br />
		<asp:Label id="lblTo" runat="server" Text="Path To" Width="58px"></asp:Label>
		<asp:Textbox id="txtTo" runat="server"></asp:Textbox>
		<input id="btnCreate" type="button" OnServerClick="btnCreate_OnClick"  value="Create" runat="server" />
		<hr />
		<asp:Label id="lblText" runat="server"></asp:Label>
	</form>
</body>
</html>
<!--- This file download from www.shotdev.com -->

