<%@ import Namespace="System.Data" %>
<%@ import Namespace="System.Data.OleDb" %>
<%@ Page Language="VB" %>
<script runat="server">
    Dim objConn As OleDbConnection
    Dim objCmd As OleDbCommand
	Dim strSQL As String

    Sub Page_Load(sender As Object, e As EventArgs)
           Dim strConnString As String
           strConnString = "Provider=Microsoft.Jet.OLEDB.4.0;Data Source="& _
		   Server.MapPath("database/mydatabase.mdb")&";"
           objConn = New OleDbConnection(strConnString)
           objConn.Open()
		   
		   IF NOT Page.IsPostBack() Then
			BindData()
		   End IF
    End Sub

	Sub BindData()
	   strSQL = "SELECT * FROM category"

	   Dim dtReader As OleDbDataReader
	   objCmd = New OleDbCommand(strSQL, objConn)
	   dtReader = objCmd.ExecuteReader()

	   '*** BindData to DataList ***'
	   myDataList.DataSource = dtReader
	   myDataList.DataBind()

	   dtReader.Close()
	   dtReader = Nothing

	End Sub

	Sub Page_UnLoad()
	   objConn.Close()
	   objConn = Nothing
	End Sub

	Sub myDataList_EditCommand(sender As Object, e As DataListCommandEventArgs)
		myDataList.EditItemIndex = e.Item.ItemIndex
		BindData()
	End Sub

	Sub myDataList_CancelCommand(sender As Object, e As DataListCommandEventArgs)
		myDataList.EditItemIndex = -1
		BindData()
	End Sub

	Sub myDataList_UpdateCommand(sender As Object, e As DataListCommandEventArgs)

		'*** CategoryID ***'
		Dim lblCateID As Label = CType(e.Item.FindControl("lblCateID"),Label)
		'*** Category ***'
		Dim txtCategory As Textbox = CType(e.Item.FindControl("txtCategory"),Textbox)
		

		strSQL = "UPDATE category SET CategoryName = '" & txtCategory.Text & "' " & _
		" WHERE CategoryID = " & lblCateID.Text & " "
		objCmd = New OleDbCommand(strSQL, objConn)
		objCmd.ExecuteNonQuery()
		
        '*** If Select File Upload ***'
        Dim filPicture As HtmlInputFile = CType(e.Item.FindControl("filPicture"), HtmlInputFile)
        Dim strFileName As String
        If Trim(filPicture.PostedFile.FileName) <> "" Then
            strFileName = System.IO.Path.GetFileName(filPicture.Value)
            filPicture.PostedFile.SaveAs(Server.MapPath(strFileName))
            strSQL = "UPDATE category SET Picture = '" & strFileName & "' " & _
            " WHERE CategoryID = " & lblCateID.Text & " "
            objCmd = New OleDbCommand(strSQL, objConn)
            objCmd.ExecuteNonQuery()
        End If

		myDataList.EditItemIndex = -1
		BindData()
	End Sub

	Private Sub myDataList_ItemDataBound(sender As Object, e As DataListItemEventArgs) 
		'*** Image ***'
		Dim img As Image = CType(e.Item.FindControl("imgPicture"),Image)
		IF Not IsNothing(img) Then
			img.ImageURL = "images/" & e.Item.DataItem("Picture")
			'img.Attributes.Add("OnClick","window.location='http://www.shotdev.com?Cateid="&e.Item.DataItem("CategoryID")&"'")
			'img.Style.Add("cursor","hand")
		End IF

		'*** HyperLink ***'		
		Dim hplCate As Hyperlink = CType(e.Item.FindControl("hplCategory"),Hyperlink)
		IF Not IsNothing(hplCate) Then
			hplCate.Text = e.Item.DataItem("CategoryName")
			hplCate.ToolTip = e.Item.DataItem("CategoryName")
			hplCate.Navigateurl = "http://www.shotdev.com?Cateid="&e.Item.DataItem("CategoryID")
		End IF
	End Sub

</script>
<html>
<head>
    <title>ShotDev.Com Tutorial</title>
</head>
<body>
	<form id="form1" runat="server" enctype="multipart/form-data">
    <asp:DataList id="myDataList" 
	onItemDataBound="myDataList_ItemDataBound" 
	onEditCommand="myDataList_EditCommand"
	onCancelCommand="myDataList_CancelCommand"
	onUpdateCommand="myDataList_UpdateCommand"
	runat="server" RepeatColumns="2"	
	cellpadding="2"
	cellspacing="2"
	borderstyle="inset">
        <HeaderTemplate>
            <b>My Category</b><br/>
        </HeaderTemplate>
        <ItemTemplate>
            <div style="width:100px" align="center">
                <asp:Image id="imgPicture" runat="server"></asp:Image>
                <br />
                <asp:HyperLink id="hplCategory" runat="server"></asp:HyperLink>
                <br />
                <asp:LinkButton id="lnkEdit" runat="server" CommandName="Edit">Edit</asp:LinkButton>
			</div>
		</ItemTemplate>
		<EditItemTemplate>
		  <asp:Label id="lblCateID" runat="server" Visible = "False" text='<%#Container.DataItem("CategoryID")%>'></asp:Label>	
		  <asp:TextBox id="txtCategory" runat="server" text='<%#Container.DataItem("CategoryName")%>'></asp:TextBox><br />
		  <input id="filPicture" type="file" runat="server"><br />
		  &nbsp;<asp:LinkButton id="lnkUpdate" runat="server" CommandName="Update">Update</asp:LinkButton>
		  <asp:LinkButton id="lnkCancel" runat="server" CommandName="Cancel">Cancel</asp:LinkButton>
		</EditItemTemplate>
    </asp:DataList>
	</form>
</body>
</html>
<!--- This file download from www.shotdev.com -->