Imports System.Data
Imports System.Data.OleDb
Partial Class DetailsViewGridView
    Inherits System.Web.UI.Page
    Dim objConn As OleDbConnection
    Dim objCmd As OleDbCommand
    Dim strSQL As String
    Dim strCusID As String = ""

    Protected Sub Page_Load(ByVal sender As Object, ByVal e As System.EventArgs) Handles Me.Load
        Dim strConnString As String
        strConnString = "Provider=Microsoft.Jet.OLEDB.4.0;Data Source=" & Server.MapPath("database/mydatabase.mdb") & ";"
        objConn = New OleDbConnection(strConnString)
        objConn.Open()

        If Not Page.IsPostBack() Then
            GridViewBindData()
        End If
    End Sub

    Protected Sub GridViewBindData()
        strSQL = "SELECT * FROM customer"

        Dim dtReader As OleDbDataReader
        objCmd = New OleDbCommand(strSQL, objConn)
        dtReader = objCmd.ExecuteReader()

        '*** BindData to GridView ***'
        myGridView.DataSource = dtReader
        myGridView.DataBind()

        dtReader.Close()
        dtReader = Nothing
    End Sub

    Protected Sub DetailsViewBindData()
        strSQL = "SELECT * FROM customer WHERE CustomerID = '" & strCusID & "' "
        Dim dtReader As OleDbDataReader
        objCmd = New OleDbCommand(strSQL, objConn)
        dtReader = objCmd.ExecuteReader()

        '*** BindData to DetailsView ***'
        myDetailsView.DataSource = dtReader
        myDetailsView.DataBind()

        dtReader.Close()
        dtReader = Nothing

    End Sub

    Protected Sub Page_Unload(ByVal sender As Object, ByVal e As System.EventArgs) Handles Me.Unload
        objConn.Close()
        objConn = Nothing
    End Sub


    Protected Sub myGridView_RowEditing(ByVal sender As Object, ByVal e As GridViewEditEventArgs) Handles myGridView.RowEditing
        myGridView.Visible = False
        strCusID = myGridView.DataKeys(e.NewEditIndex).Value.ToString
        myDetailsView.Visible = True
        DetailsViewBindData()
    End Sub

    Protected Sub myDetailsView_ModeChanging(ByVal sender As Object, ByVal e As DetailsViewModeEventArgs) Handles myDetailsView.ModeChanging
        Select Case e.NewMode
            Case DetailsViewMode.Edit
                Dim lblCusID As Label = CType(myDetailsView.FindControl("lblCusID"), Label)
                strCusID = lblCusID.Text
                myDetailsView.ChangeMode(DetailsViewMode.Edit)
                DetailsViewBindData()
            Case DetailsViewMode.ReadOnly
                myDetailsView.ChangeMode(DetailsViewMode.ReadOnly)
                myDetailsView.Visible = False
                myGridView.Visible = True
                GridViewBindData()
        End Select
    End Sub

    Protected Sub myDetailsView_ItemUpdating(ByVal sender As Object, ByVal e As DetailsViewUpdateEventArgs) Handles myDetailsView.ItemUpdating
        '*** Old CusID ***'
        Dim lblCusID As Label = CType(myDetailsView.FindControl("lblCusID"), Label)
        strCusID = lblCusID.Text
        '*** CustomerID ***'
        Dim txtCustomerID As TextBox = CType(myDetailsView.FindControl("txtEditCustomerID"), TextBox)
        '*** Email ***'
        Dim txtName As TextBox = CType(myDetailsView.FindControl("txtEditName"), TextBox)
        '*** Name ***'
        Dim txtEmail As TextBox = CType(myDetailsView.FindControl("txtEditEmail"), TextBox)
        '*** CountryCode ***'
        Dim txtCountryCode As TextBox = CType(myDetailsView.FindControl("txtEditCountryCode"), TextBox)
        '*** Budget ***'
        Dim txtBudget As TextBox = CType(myDetailsView.FindControl("txtEditBudget"), TextBox)
        '*** Used ***'
        Dim txtUsed As TextBox = CType(myDetailsView.FindControl("txtEditUsed"), TextBox)

        strSQL = "UPDATE customer SET CustomerID = '" & txtCustomerID.Text & "' " & _
        " ,Name = '" & txtName.Text & "' " & _
        " ,Email = '" & txtEmail.Text & "' " & _
        " ,CountryCode = '" & txtCountryCode.Text & "' " & _
        " ,Budget = '" & txtBudget.Text & "' " & _
        " ,Used = '" & txtUsed.Text & "' " & _
        " WHERE CustomerID = '" & strCusID & "'"

        objCmd = New OleDbCommand(strSQL, objConn)
        objCmd.ExecuteNonQuery()
        myDetailsView.ChangeMode(DetailsViewMode.ReadOnly)
        myDetailsView.Visible = False
        myGridView.Visible = True
        GridViewBindData()
    End Sub


End Class
