<%@ import Namespace="System.Data" %>
<%@ import Namespace="System.Data.OleDb" %>
<%@ Page Language="VB" %>
<script runat="server">
	Dim strFields As String = "CustomerID"
    Sub Page_Load(sender As Object, e As EventArgs)		
		IF Not Page.IsPostBack() Then
			BindData()
		End IF
    End Sub

	Sub BindData()

        Dim objConn As New OleDbConnection
		Dim objCmd As New OleDbCommand
        Dim dtAdapter As New OleDbDataAdapter       
		Dim ds As New DataSet
		Dim strConnString,strSQL As String

		strConnString = "Provider=Microsoft.Jet.OLEDB.4.0;Data Source="& _ 
		Server.MapPath("database/mydatabase.mdb")&";"
		strSQL = "SELECT * FROM customer ORDER BY " & strFields & " ASC"

		objConn.ConnectionString = strConnString
		With objCmd
			.Connection = objConn
			.CommandText = strSQL			
			.CommandType = CommandType.Text
		End With
		dtAdapter.SelectCommand = objCmd

		dtAdapter.Fill(ds)

		'*** BindData to GridView ***'
		myGridView.DataSource = ds
		myGridView.DataBind()

		dtAdapter = Nothing		
		objConn.Close()
		objConn = Nothing

	End Sub
	
	Sub SortCommand(s As Object, e As GridViewSortEventArgs)
		strFields = e.SortExpression
		BindData()
	End Sub

	Private Sub myGridView_RowDataBound(sender As Object, e As GridViewRowEventArgs) 
		'*** CustomerID ***'
		Dim lblCustomerID As Label = CType(e.Row.FindControl("lblCustomerID"),Label)
		IF Not IsNothing(lblCustomerID) Then
			lblCustomerID.Text = e.Row.DataItem("CustomerID")
		End IF

		'*** Name ***'
		Dim lblName As Label = CType(e.Row.FindControl("lblName"),Label)
		IF Not IsNothing(lblName) Then
			lblName.Text = e.Row.DataItem("Name")
		End IF

		'*** Email ***'
		Dim lblEmail As Label = CType(e.Row.FindControl("lblEmail"),Label)
		IF Not IsNothing(lblEmail) Then
			lblEmail.Text = e.Row.DataItem("Email")
		End IF

		'*** CountryCode ***'
		Dim lblCountryCode As Label = CType(e.Row.FindControl("lblCountryCode"),Label)
		IF Not IsNothing(lblCountryCode) Then
			lblCountryCode.Text = e.Row.DataItem("CountryCode")
		End IF

		'*** Budget ***'
		Dim lblBudget As Label = CType(e.Row.FindControl("lblBudget"),Label)
		IF Not IsNothing(lblBudget) Then
			lblBudget.Text = FormatNumber(e.Row.DataItem("Budget"),2)
		End IF

		'*** Used ***'
		Dim lblUsed As Label = CType(e.Row.FindControl("lblUsed"),Label)
		IF Not IsNothing(lblUsed) Then
			lblUsed.Text = FormatNumber(e.Row.DataItem("Used"),2)
		End IF
	End Sub

</script>
<html>
<head>
    <title>ShotDev.Com Tutorial</title>
</head>
<body>
<form id="form1" runat="server">
<asp:GridView id="myGridView" runat="server"   
	AllowSorting="True" OnSorting="SortCommand"
	AutoGenerateColumns="False" onRowDataBound="myGridView_RowDataBound">
	<Columns>

	<asp:TemplateField SortExpression="CustomerID"  HeaderText="CustomerID">
		<ItemTemplate>
			<asp:Label id="lblCustomerID" runat="server"></asp:Label>
		</ItemTemplate>
	</asp:TemplateField>

	<asp:TemplateField SortExpression="Name" HeaderText="Name">
		<ItemTemplate>
			<asp:Label id="lblName" runat="server"></asp:Label>
		</ItemTemplate>
	</asp:TemplateField>

	<asp:TemplateField SortExpression="Email" HeaderText="Email">
		<ItemTemplate>
			<asp:Label id="lblEmail" runat="server"></asp:Label>
		</ItemTemplate>
	</asp:TemplateField>

	<asp:TemplateField SortExpression="CountryCode" HeaderText="CountryCode">
		<ItemTemplate>
			<asp:Label id="lblCountryCode" runat="server"></asp:Label>
		</ItemTemplate>
	</asp:TemplateField>

	<asp:TemplateField SortExpression="Budget" HeaderText="Budget">
		<ItemTemplate>
			<asp:Label id="lblBudget" runat="server"></asp:Label>
		</ItemTemplate>
	</asp:TemplateField>

	<asp:TemplateField SortExpression="Used" HeaderText="Used">
		<ItemTemplate>
			<asp:Label id="lblUsed" runat="server"></asp:Label>
		</ItemTemplate>
	</asp:TemplateField>

	</Columns>
</asp:GridView>
</form>
</body>
</html>
<!--- This file download from www.shotdev.com -->