<%@ Import Namespace="System.Data"%>
<%@ Import Namespace="System.Data.OleDb"%>
<%@ Page Language="VB" %>
<script runat="server">

    Sub Page_Load(sender As Object, e As EventArgs)
		IF Not Page.IsPostBack() Then
			ListBoxDataTable()
			ListBoxDataTableRows()
			ListBoxSortedList()
			ListBoxAddInsertItem()
		End IF
    End Sub

	'*** ListBox & DataTable ***'
	Function ListBoxDataTable()
		Dim objConn As OleDbConnection
		Dim dtAdapter As OleDbDataAdapter 
		Dim dt As New DataTable
			  
		Dim strConnString As String
		strConnString = "Provider=Microsoft.Jet.OLEDB.4.0;Data Source="& _
		Server.MapPath("shotdev/mydatabase.mdb")&";"
		objConn = New OleDbConnection(strConnString)
		objConn.Open()

		Dim strSQL As String		
		strSQL = "SELECT * FROM country"

		dtAdapter = New OleDbDataAdapter(strSQL, objConn)
		dtAdapter.Fill(dt)

		dtAdapter = Nothing
		objConn.Close()
		objConn = Nothing

		'*** ListBox ***'
		With Me.myListBox1
			.DataSource = dt
			.DataTextField = "CountryName"
			.DataValueField = "CountryCode"
			.DataBind()
		End With
		
		'*** Default Value ***'
		myListBox1.SelectedIndex = myListBox1.Items.IndexOf(myListBox1.Items.FindByValue("TH"))  '*** By DataValueField ***'
		'myListBox1.SelectedIndex = myListBox1.Items.IndexOf(myListBox1.Items.FindByText("Thailand"))  '*** By DataTextField ***'

	End Function

	'*** ListBox & TableRows ***'
	Sub ListBoxDataTableRows()
        Dim dt As New DataTable
        Dim dr As DataRow
		
		'*** Column ***'
        dt.Columns.Add("Sex")
        dt.Columns.Add("SexDesc")
		
		'*** Rows ***'
		dr = dt.NewRow
        dr("Sex") = "M"
        dr("SexDesc") = "Man"
        dt.Rows.Add(dr)

		'*** Rows ***'
		dr = dt.NewRow
        dr("Sex") = "W"
        dr("SexDesc") = "Woman"
        dt.Rows.Add(dr)

		'*** ListBox ***'
		With Me.myListBox2
				.DataSource = dt
				.DataTextField = "SexDesc"
				.DataValueField = "Sex"
				.DataBind()
		End With

		'*** Default Value ***'
		myListBox2.SelectedIndex = myListBox2.Items.IndexOf(myListBox2.Items.FindByValue("W"))  '*** By DataValueField ***'
		'myListBox2.SelectedIndex = myListBox2.Items.IndexOf(myListBox2.Items.FindByText("Woman"))  '*** By DataTextField ***'

	End Sub

	'*** ListBox & SortedList ***'
	Sub ListBoxSortedList()
        Dim mySortedList AS New SortedList 
		
		mySortedList.Add("M","Man")
		mySortedList.Add("W","Woman")

		'*** ListBox ***'
		With Me.myListBox3
			.DataSource = mySortedList
			.DataTextField = "Value"
			.DataValueField = "Key"
			.DataBind()
		End With
		
		'*** Default Value ***'
		myListBox3.SelectedIndex = myListBox3.Items.IndexOf(myListBox3.Items.FindByValue("W"))  '*** By DataValueField ***'
		'myListBox3.SelectedIndex = myListBox3.Items.IndexOf(myListBox3.Items.FindByText("Woman"))  '*** By DataTextField ***'
	End Sub


	'*** Add/Insert Items ***'
	Sub ListBoxAddInsertItem()
        Dim mySortedList AS New SortedList 
		
		mySortedList.Add("M","Man")
		mySortedList.Add("W","Woman")

		'*** ListBox ***'
		With Me.myListBox4
			.DataSource = mySortedList
			.DataTextField = "Value"
			.DataValueField = "Key"
			.DataBind()
		End With
		

		'*** Add & Insert New Item ***'
		Dim strText,strValue As String

		'*** Insert Item ***'
		strText = ""
		strValue = ""
		Dim InsertItem As New ListItem(strText, strValue)
		myListBox4.Items.Insert(0, InsertItem)

		'*** Add Items ***'		
		strText = "Guy"
		strValue = "G"
		Dim AddItem As New ListItem(strText, strValue)
		myListBox4.Items.Add(AddItem)

		'*** Default Value ***'
		myListBox4.SelectedIndex = myListBox4.Items.IndexOf(myListBox4.Items.FindByValue("W"))  '*** By DataValueField ***'
		'myListBox4.SelectedIndex = myListBox4.Items.IndexOf(myListBox4.Items.FindByText("Woman"))  '*** By DataTextField ***'
	End Sub

    Sub Button1_OnClick(sender as Object, e As EventArgs)
        Me.lblText1.Text = Me.myListBox1.SelectedItem.Value  '*** Or Me.myListBox1.SelectedItem.Text ***'
		Me.lblText2.Text = Me.myListBox2.SelectedItem.Value  '*** Or Me.myListBox2.SelectedItem.Text ***'

		'*** SelectionMode="Multiple" ***'
		Dim i As Integer
		Me.lblText3.Text = ""
		For i = 0 To Me.myListBox3.Items.Count - 1
			If Me.myListBox3.Items(i).Selected Then
				Me.lblText3.Text = Me.lblText3.Text & ","&Me.myListBox3.Items(i).Value '*** Or Me.myListBox3.Items(i).Text ***'
			End If
		Next

		Me.lblText4.Text = Me.myListBox4.SelectedItem.Value  '*** Or Me.myListBox4.SelectedItem.Text ***'
    End Sub

</script>
<html>
<head>
    <title>ShotDev.Com Tutorial</title>
</head>
<body>
	<form id="form1" runat="server">
		<asp:ListBox id="myListBox1" runat="server"></asp:ListBox> 
		<asp:ListBox id="myListBox2" runat="server"></asp:ListBox>
		<asp:ListBox id="myListBox3" SelectionMode="Multiple" runat="server"></asp:ListBox>
		<asp:ListBox id="myListBox4" runat="server"></asp:ListBox>
		<asp:Button id="Button1" onclick="Button1_OnClick" runat="server" Text="Button"></asp:Button>
		<hr />
		<asp:Label id="lblText1" runat="server"></asp:Label><br />
		<asp:Label id="lblText2" runat="server"></asp:Label><br />
		<asp:Label id="lblText3" runat="server"></asp:Label><br />
		<asp:Label id="lblText4" runat="server"></asp:Label><br />
	</form>
</body>
</html>
<!--- This file download from www.shotdev.com -->