﻿Imports System.Data
Imports System.Data.OleDb

Partial Class ListView1
    Inherits System.Web.UI.Page

    Dim objConn As OleDbConnection
    Dim objCmd As OleDbCommand

    Protected Sub Page_Load(ByVal sender As Object, ByVal e As System.EventArgs) Handles Me.Load
        Dim strConnString As String
        strConnString = "Provider=Microsoft.Jet.OLEDB.4.0;Data Source=" & Server.MapPath("db/mydatabase.mdb") & ";"
        objConn = New OleDbConnection(strConnString)
        objConn.Open()

        If Not Page.IsPostBack() Then
            BindData()
        End If
    End Sub

    Protected Sub BindData()
        Dim strSQL As String
        strSQL = "SELECT * FROM customer"

        Dim dtReader As OleDbDataReader
        objCmd = New OleDbCommand(strSQL, objConn)
        dtReader = objCmd.ExecuteReader()

        '*** BindData to ListView ***'
        myListView.DataSource = dtReader
        myListView.DataBind()

        dtReader.Close()
        dtReader = Nothing

    End Sub

	Sub Page_UnLoad()
		objConn.Close()
		objConn = Nothing
	End Sub

    Protected Sub myListView_ItemDataBound(ByVal sender As Object, ByVal e As ListViewItemEventArgs) Handles myListView.ItemDataBound

        Dim lvDataItem As ListViewDataItem = CType(e.Item, ListViewDataItem)

        '*** CustomerID ***'
        Dim lblCustomerID As Label = CType(e.Item.FindControl("lblCustomerID"), Label)
        If Not IsNothing(lblCustomerID) Then
            lblCustomerID.Text = lvDataItem.DataItem("CustomerID")
        End If

        '*** Name ***'
        Dim lblName As Label = CType(e.Item.FindControl("lblName"), Label)
        If Not IsNothing(lblName) Then
            lblName.Text = lvDataItem.DataItem("CustomerID")
        End If

        '*** Email ***'
        Dim lblEmail As Label = CType(e.Item.FindControl("lblEmail"), Label)
        If Not IsNothing(lblEmail) Then
            lblEmail.Text = lvDataItem.DataItem("Email")
        End If

        '*** CountryCode ***'
        Dim lblCountryCode As Label = CType(e.Item.FindControl("lblCountryCode"), Label)
        If Not IsNothing(lblCountryCode) Then
            lblCountryCode.Text = lvDataItem.DataItem("CountryCode")
        End If

        '*** Budget ***'
        Dim lblBudget As Label = CType(e.Item.FindControl("lblBudget"), Label)
        If Not IsNothing(lblBudget) Then
            lblBudget.Text = lvDataItem.DataItem("Budget")
        End If

        '*** Used ***'
        Dim lblUsed As Label = CType(e.Item.FindControl("lblUsed"), Label)
        If Not IsNothing(lblUsed) Then
            lblUsed.Text = lvDataItem.DataItem("Used")
        End If
    End Sub

    Sub Button1_Click(ByVal sender As Object, ByVal e As EventArgs) Handles Button1.Click
        Dim chkCusID As CheckBox
        Dim lblID As Label
        Dim i As Integer
        lblText.Text = ""
        For i = 0 To myListView.Items.Count - 1
            chkCusID = myListView.Items(i).FindControl("chkCustomerID")
            lblID = myListView.Items(i).FindControl("lblCustomerID")
            If chkCusID.Checked = True Then
                '*** Have lblID.Text ***'
                Me.lblText.Text = Me.lblText.Text & "<br>" & lblID.Text
            End If
        Next
    End Sub

End Class