Imports System.Data
Imports System.Data.Odbc
Partial Class OdbcSQLServer
    Inherits System.Web.UI.Page
    Dim objConn As OdbcConnection
    Dim objCmd As OdbcCommand
    Dim strSQL As String

    Protected Sub Page_Load(ByVal sender As Object, ByVal e As System.EventArgs) Handles Me.Load
        Dim strConnString As String
        strConnString = "Driver={SQL Server};Server=localhost;Database=mydatabase;UID=sa;PWD=;"
        objConn = New OdbcConnection(strConnString)
        objConn.Open()

        If Not Page.IsPostBack() Then
            BindData()
        End If
    End Sub

    Protected Sub BindData()
        strSQL = "SELECT * FROM customer"

        Dim dtReader As OdbcDataReader
        objCmd = New OdbcCommand(strSQL, objConn)
        dtReader = objCmd.ExecuteReader()

        '*** BindData to GridView ***'
        myGridView.DataSource = dtReader
        myGridView.DataBind()

        dtReader.Close()
        dtReader = Nothing
    End Sub

    Protected Sub Page_Unload(ByVal sender As Object, ByVal e As System.EventArgs) Handles Me.Unload
        objConn.Close()
        objConn = Nothing
    End Sub

    Protected Sub myGridView_RowCancelingEdit(ByVal sender As Object, ByVal e As GridViewCancelEditEventArgs) Handles myGridView.RowCancelingEdit
        myGridView.EditIndex = -1
        myGridView.ShowFooter = True
        BindData()
    End Sub

    Protected Sub myGridView_RowCommand(ByVal sender As Object, ByVal e As GridViewCommandEventArgs) Handles myGridView.RowCommand
        If e.CommandName = "Add" Then
            '*** CustomerID ***'
            Dim txtCustomerID As TextBox = CType(myGridView.FooterRow.FindControl("txtAddCustomerID"), TextBox)
            '*** Name ***'
            Dim txtName As TextBox = CType(myGridView.FooterRow.FindControl("txtAddName"), TextBox)
            '*** Email ***'
            Dim txtEmail As TextBox = CType(myGridView.FooterRow.FindControl("txtAddEmail"), TextBox)
            '*** CountryCode ***'
            Dim txtCountryCode As TextBox = CType(myGridView.FooterRow.FindControl("txtAddCountryCode"), TextBox)
            '*** Budget ***'
            Dim txtBudget As TextBox = CType(myGridView.FooterRow.FindControl("txtAddBudget"), TextBox)
            '*** Used ***'
            Dim txtUsed As TextBox = CType(myGridView.FooterRow.FindControl("txtAddUsed"), TextBox)

            strSQL = "INSERT INTO customer (CustomerID,Name,Email,CountryCode,Budget,Used) " & _
            " VALUES ('" & txtCustomerID.Text & "','" & txtName.Text & "','" & txtEmail.Text & "' " & _
            " ,'" & txtCountryCode.Text & "','" & txtBudget.Text & "','" & txtUsed.Text & "') "
            objCmd = New OdbcCommand(strSQL, objConn)
            objCmd.ExecuteNonQuery()

            BindData()
        End If
    End Sub

    Protected Sub myGridView_RowDeleting(ByVal sender As Object, ByVal e As GridViewDeleteEventArgs) Handles myGridView.RowDeleting
        strSQL = "DELETE FROM customer WHERE CustomerID = '" & myGridView.DataKeys.Item(e.RowIndex).Value & "'"
        objCmd = New OdbcCommand(strSQL, objConn)
        objCmd.ExecuteNonQuery()

        myGridView.EditIndex = -1
        BindData()
    End Sub

    Protected Sub myGridView_RowEditing(ByVal sender As Object, ByVal e As GridViewEditEventArgs) Handles myGridView.RowEditing
        myGridView.EditIndex = e.NewEditIndex
        myGridView.ShowFooter = False
        BindData()
    End Sub

    Protected Sub myGridView_RowUpdating(ByVal sender As Object, ByVal e As GridViewUpdateEventArgs) Handles myGridView.RowUpdating
        '*** CustomerID ***'
        Dim txtCustomerID As TextBox = CType(myGridView.Rows(e.RowIndex).FindControl("txtEditCustomerID"), TextBox)
        '*** Name ***'
        Dim txtName As TextBox = CType(myGridView.Rows(e.RowIndex).FindControl("txtEditName"), TextBox)
        '*** Email ***'
        Dim txtEmail As TextBox = CType(myGridView.Rows(e.RowIndex).FindControl("txtEditEmail"), TextBox)
        '*** CountryCode ***'
        Dim txtCountryCode As TextBox = CType(myGridView.Rows(e.RowIndex).FindControl("txtEditCountryCode"), TextBox)
        '*** Budget ***'
        Dim txtBudget As TextBox = CType(myGridView.Rows(e.RowIndex).FindControl("txtEditBudget"), TextBox)
        '*** Used ***'
        Dim txtUsed As TextBox = CType(myGridView.Rows(e.RowIndex).FindControl("txtEditUsed"), TextBox)

        strSQL = "UPDATE customer SET CustomerID = '" & txtCustomerID.Text & "' " & _
        " ,Name = '" & txtName.Text & "' " & _
        " ,Email = '" & txtEmail.Text & "' " & _
        " ,CountryCode = '" & txtCountryCode.Text & "' " & _
        " ,Budget = '" & txtBudget.Text & "' " & _
        " ,Used = '" & txtUsed.Text & "' " & _
        " WHERE CustomerID = '" & myGridView.DataKeys.Item(e.RowIndex).Value & "'"
        objCmd = New OdbcCommand(strSQL, objConn)
        objCmd.ExecuteNonQuery()

        myGridView.EditIndex = -1
        myGridView.ShowFooter = True
        BindData()
    End Sub
End Class
