<%@ Import Namespace="System.Data"%>
<%@ Import Namespace="System.Data.OracleClient"%>
<%@ Page Language="VB" %>
<script runat="server">
    Dim objConn As OracleConnection
    Dim objCmd As OracleCommand

    Sub Page_Load(sender As Object, e As EventArgs)
		Dim strConnString As String
		strConnString = "Data Source=TCDB;User Id=myuser;Password=mypassword;"
		objConn = New OracleConnection(strConnString)
		objConn.Open()

        BindData()
    End Sub

   Sub BindData()
	   Dim strSQL As String
	   strSQL = "SELECT * FROM customer"

	   Dim dtReader As OracleDataReader
	   objCmd = New OracleCommand(strSQL, objConn)
	   dtReader = objCmd.ExecuteReader()

	   '*** BindData to GridView ***'
	   myGridView.DataSource = dtReader
	   myGridView.DataBind()

	   dtReader.Close()
	   dtReader = Nothing

   End Sub

   Sub Page_UnLoad()
	   objConn.Close()
	   objConn = Nothing
   End Sub

	Private Sub myGridView_RowDataBound(sender As Object, e As GridViewRowEventArgs) 
		'*** CustomerID ***'
		Dim lblCustomerID As Label = CType(e.Row.FindControl("lblCustomerID"),Label)
		IF Not IsNothing(lblCustomerID) Then
			lblCustomerID.Text = e.Row.DataItem("CustomerID")
		End IF

		'*** Name ***'
		Dim lblName As Label = CType(e.Row.FindControl("lblName"),Label)
		IF Not IsNothing(lblName) Then
			lblName.Text = e.Row.DataItem("Name")
		End IF

		'*** Email ***'
		Dim lblEmail As Label = CType(e.Row.FindControl("lblEmail"),Label)
		IF Not IsNothing(lblEmail) Then
			lblEmail.Text = e.Row.DataItem("Email")
		End IF

		'*** CountryCode ***'
		Dim lblCountryCode As Label = CType(e.Row.FindControl("lblCountryCode"),Label)
		IF Not IsNothing(lblCountryCode) Then
			lblCountryCode.Text = e.Row.DataItem("CountryCode")
		End IF

		'*** Budget ***'
		Dim lblBudget As Label = CType(e.Row.FindControl("lblBudget"),Label)
		IF Not IsNothing(lblBudget) Then
			lblBudget.Text = FormatNumber(e.Row.DataItem("Budget"),2)
		End IF

		'*** Used ***'
		Dim lblUsed As Label = CType(e.Row.FindControl("lblUsed"),Label)
		IF Not IsNothing(lblUsed) Then
			lblUsed.Text = FormatNumber(e.Row.DataItem("Used"),2)
		End IF
	End Sub

</script>
<html>
<head>
    <title>ShotDev.Com Tutorial</title>
</head>
<body>
<form id="form1" runat="server">
<asp:GridView id="myGridView" runat="server" AutoGenerateColumns="False" onRowDataBound="myGridView_RowDataBound">

	<Columns>

	<asp:TemplateField HeaderText="CustomerID">
		<ItemTemplate>
			<asp:Label id="lblCustomerID" runat="server"></asp:Label>
		</ItemTemplate>
	</asp:TemplateField>

	<asp:TemplateField HeaderText="Name">
		<ItemTemplate>
			<asp:Label id="lblName" runat="server"></asp:Label>
		</ItemTemplate>
	</asp:TemplateField>

	<asp:TemplateField HeaderText="Email">
		<ItemTemplate>
			<asp:Label id="lblEmail" runat="server"></asp:Label>
		</ItemTemplate>
	</asp:TemplateField>

	<asp:TemplateField HeaderText="CountryCode">
		<ItemTemplate>
			<asp:Label id="lblCountryCode" runat="server"></asp:Label>
		</ItemTemplate>
	</asp:TemplateField>

	<asp:TemplateField HeaderText="Budget">
		<ItemTemplate>
			<asp:Label id="lblBudget" runat="server"></asp:Label>
		</ItemTemplate>
	</asp:TemplateField>

	<asp:TemplateField HeaderText="Used">
		<ItemTemplate>
			<asp:Label id="lblUsed" runat="server"></asp:Label>
		</ItemTemplate>
	</asp:TemplateField>

	</Columns>
</asp:GridView>
</form>
</body>
</html>
<!--- This file download from www.shotdev.com -->