<%@ Import Namespace="System.Data"%>
<%@ Import Namespace="System.Data.OracleClient"%>
<%@ Page Language="VB" %>
<script runat="server">
    Sub Page_Load(sender As Object, e As EventArgs)		
		IF Not Page.IsPostBack() Then
			BindData()
		End IF
    End Sub

	Sub BindData()

        Dim objConn As New OracleConnection
		Dim objCmd As New OracleCommand
        Dim dtAdapter As New OracleDataAdapter       
		Dim ds As New DataSet
		Dim strConnString,strSQL As String

		strConnString = "Data Source=TCDB;User Id=myuser;Password=mypassword;"
		strSQL = "SELECT * FROM customer"

		objConn.ConnectionString = strConnString
		With objCmd
			.Connection = objConn
			.CommandText = strSQL			
			.CommandType = CommandType.Text
		End With
		dtAdapter.SelectCommand = objCmd

		dtAdapter.Fill(ds)

		'*** BindData to GridView ***'
		myGridView.DataSource = ds
		myGridView.DataBind()

		dtAdapter = Nothing		
		objConn.Close()
		objConn = Nothing

	End Sub

	Sub myGridView_RowDataBound(sender As Object, e As GridViewRowEventArgs) 
		'*** CustomerID ***'
		Dim lblCustomerID As Label = CType(e.Row.FindControl("lblCustomerID"),Label)
		IF Not IsNothing(lblCustomerID) Then
			lblCustomerID.Text = e.Row.DataItem("CustomerID")
		End IF

		'*** Name ***'
		Dim lblName As Label = CType(e.Row.FindControl("lblName"),Label)
		IF Not IsNothing(lblName) Then
			lblName.Text = e.Row.DataItem("Name")
		End IF

		'*** Email ***'
		Dim lblEmail As Label = CType(e.Row.FindControl("lblEmail"),Label)
		IF Not IsNothing(lblEmail) Then
			lblEmail.Text = e.Row.DataItem("Email")
		End IF

		'*** CountryCode ***'
		Dim lblCountryCode As Label = CType(e.Row.FindControl("lblCountryCode"),Label)
		IF Not IsNothing(lblCountryCode) Then
			lblCountryCode.Text = e.Row.DataItem("CountryCode")
		End IF

		'*** Budget ***'
		Dim lblBudget As Label = CType(e.Row.FindControl("lblBudget"),Label)
		IF Not IsNothing(lblBudget) Then
			lblBudget.Text = FormatNumber(e.Row.DataItem("Budget"),2)
		End IF

		'*** Used ***'
		Dim lblUsed As Label = CType(e.Row.FindControl("lblUsed"),Label)
		IF Not IsNothing(lblUsed) Then
			lblUsed.Text = FormatNumber(e.Row.DataItem("Used"),2)
		End IF
	End Sub
	
	Sub ShowPageCommand(s As Object, e As GridViewPageEventArgs)
		myGridView.PageIndex = e.NewPageIndex
		BindData()
	End Sub	
</script>
<html>
<head>
    <title>ShotDev.Com Tutorial</title>
</head>
<body>
	<form id="form1" runat="server">
		<asp:GridView id="myGridView" PageSize="2" 
		OnPageIndexChanging="ShowPageCommand"
		onRowDataBound="myGridView_RowDataBound"
		AutoGenerateColumns="False" AllowPaging="True" runat="server">
		<HeaderStyle BackColor="#cccccc"></HeaderStyle>
		<AlternatingRowStyle BackColor="#e8e8e8"></AlternatingRowStyle>

		<Columns>

		<asp:TemplateField HeaderText="CustomerID">
			<ItemTemplate>
				<asp:Label id="lblCustomerID" runat="server"></asp:Label>
			</ItemTemplate>
		</asp:TemplateField>

		<asp:TemplateField HeaderText="Name">
			<ItemTemplate>
				<asp:Label id="lblName" runat="server"></asp:Label>
			</ItemTemplate>
		</asp:TemplateField>

		<asp:TemplateField HeaderText="Email">
			<ItemTemplate>
				<asp:Label id="lblEmail" runat="server"></asp:Label>
			</ItemTemplate>
		</asp:TemplateField>

		<asp:TemplateField HeaderText="CountryCode">
			<ItemTemplate>
				<asp:Label id="lblCountryCode" runat="server"></asp:Label>
			</ItemTemplate>
		</asp:TemplateField>

		<asp:TemplateField HeaderText="Budget">
			<ItemTemplate>
				<asp:Label id="lblBudget" runat="server"></asp:Label>
			</ItemTemplate>
		</asp:TemplateField>

		<asp:TemplateField HeaderText="Used">
			<ItemTemplate>
				<asp:Label id="lblUsed" runat="server"></asp:Label>
			</ItemTemplate>
		</asp:TemplateField>

		</Columns>

		</asp:GridView>		
	</form>
</body>
</html>
<!--- This file download from www.shotdev.com -->