<%@ Import Namespace="System.Data"%>
<%@ Import Namespace="System.IO"%>
<%@ Page Language="VB" %>
<script runat="server">

    Sub Page_Load(sender As Object, e As EventArgs)
		Dim dt As DataTable		
		'*** DataTable ***'
		dt = ReadCSV()  '*** Convert CSV to DataTable ***'

		'*** BindData to Repeater ***'
		myRepeater.DataSource = dt
		myRepeater.DataBind()
    End Sub

	'*** CSV & DataTable ***'
	Function ReadCSV() As DataTable
        Dim dt As New DataTable
        Dim dr As DataRow
		
		'*** Column ***'
        dt.Columns.Add("CustomerID")
        dt.Columns.Add("Name")
        dt.Columns.Add("Email")
        dt.Columns.Add("CountryCode")
        dt.Columns.Add("Budget")
        dt.Columns.Add("Used")
		
        Dim StrWer As StreamReader      
		Dim strLine As String
		StrWer = File.OpenText(Server.MapPath("csv/customer.csv"))			
		Do Until StrWer.EndOfStream
			strLine = StrWer.ReadLine()
			IF Trim(strLine) <> "" Then
				'*** Rows ***'
				dr = dt.NewRow
				dr("CustomerID") = Split(strLine,",")(0)
				dr("Name") = Split(strLine,",")(1)
				dr("Email") = Split(strLine,",")(2)
				dr("CountryCode") = Split(strLine,",")(3)
				dr("Budget") = Split(strLine,",")(4)
				dr("Used") = Split(strLine,",")(5)
				dt.Rows.Add(dr)
		   End IF
		Loop				                             		
		StrWer.Close()

		Return dt '*** Return DataTable ***'

	End Function
</script>
<html>
<head>
    <title>ShotDev.Com Tutorial</title>
</head>
<body>
	<form id="form1" runat="server">
    <asp:Repeater id="myRepeater" runat="server">
	<HeaderTemplate>
		<table border="1">
			<tr>
				<th>CustomerID</th>
				<th>Name</th>
				<th>Email</th>
				<th>CountryCode</th>
				<th>Budget</th>
				<th>Used</th>
			</tr>
	</HeaderTemplate>
	<ItemTemplate>
		<tr>
			<td align="center"><%#Container.DataItem("CustomerID") %></td>
			<td><%#Container.DataItem("Name") %></td>
			<td><%#Container.DataItem("Email") %></td>
			<td align="center"><%#Container.DataItem("CountryCode") %></td>
			<td align="right"><%#Container.DataItem("Budget") %></td>
			<td align="right"><%#Container.DataItem("Used") %></td>
		</tr>			
	</ItemTemplate>
	</asp:Repeater>
	</form>
</body>
</html>
<!--- This file download from www.shotdev.com -->