<%@ Page Language="VB" %>
<script runat="server">
	Dim myDSource As SqlDataSource
	Dim strSQL As String
	Sub Page_Load(sender As Object, e As EventArgs)

		myDSource = New SqlDataSource()
		myDSource.ConnectionString = System.Configuration.ConfigurationSettings.AppSettings("ConnectionString")

	   IF Not Page.IsPostBack() Then	
			BindData()
	   End IF
	End Sub

	Sub BindData()	  
			
		With myDSource			
			.SelectCommand = "SELECT * FROM [customer]"
		End With

	   '*** BindData to GridView ***'
	   myGridView.DataSource = myDSource
	   myGridView.DataBind()

	   myDSource = Nothing

	End Sub

	Sub modEditCommand(sender As Object, e As GridViewEditEventArgs)
		myGridView.EditIndex = e.NewEditIndex
		myGridView.ShowFooter = False
		BindData()
	End Sub

	Sub modCancelCommand(sender As Object, e As GridViewCancelEditEventArgs)
		myGridView.EditIndex = -1
		myGridView.ShowFooter = True
		BindData()
	End Sub

	Sub modDeleteCommand(sender As Object, e As GridViewDeleteEventArgs)
        strSQL = "DELETE FROM customer WHERE CustomerID = '" & myGridView.DataKeys.Item(e.RowIndex).Value & "'"

		With myDSource			
			.DeleteCommand = strSQL
			.DeleteCommandType = SqlDataSourceCommandType.Text
            .Delete()
		End With

        myGridView.EditIndex = -1
        BindData()
	End Sub


    Sub myGridView_RowCommand(source As Object, e As GridViewCommandEventArgs)
		If e.CommandName = "Add" Then
            '*** CustomerID ***'
            Dim txtCustomerID As TextBox = CType(myGridView.FooterRow.FindControl("txtAddCustomerID"), TextBox)
            '*** Name ***'
            Dim txtName As TextBox = CType(myGridView.FooterRow.FindControl("txtAddName"), TextBox)
            '*** Email ***'
            Dim txtEmail As TextBox = CType(myGridView.FooterRow.FindControl("txtAddEmail"), TextBox)
            '*** CountryCode ***'
            Dim txtCountryCode As TextBox = CType(myGridView.FooterRow.FindControl("txtAddCountryCode"), TextBox)
            '*** Budget ***'
            Dim txtBudget As TextBox = CType(myGridView.FooterRow.FindControl("txtAddBudget"), TextBox)
            '*** Used ***'
            Dim txtUsed As TextBox = CType(myGridView.FooterRow.FindControl("txtAddUsed"), TextBox)

            strSQL = "INSERT INTO customer (CustomerID,Name,Email,CountryCode,Budget,Used) " & _
            " VALUES ('" & txtCustomerID.Text & "','" & txtName.Text & "','" & txtEmail.Text & "' " & _
            " ,'" & txtCountryCode.Text & "','" & txtBudget.Text & "','" & txtUsed.Text & "') "

			With myDSource			
				.InsertCommand = strSQL
				.InsertCommandType = SqlDataSourceCommandType.Text
				.Insert()
			End With

            BindData()
        End If
    End Sub


	Sub modUpdateCommand(s As Object, e As GridViewUpdateEventArgs)

		'*** CustomerID ***'
        Dim txtCustomerID As TextBox = CType(myGridView.Rows(e.RowIndex).FindControl("txtEditCustomerID"), TextBox)
        '*** Name ***'
        Dim txtName As TextBox = CType(myGridView.Rows(e.RowIndex).FindControl("txtEditName"), TextBox)
        '*** Email ***'
        Dim txtEmail As TextBox = CType(myGridView.Rows(e.RowIndex).FindControl("txtEditEmail"), TextBox)
        '*** CountryCode ***'
        Dim txtCountryCode As TextBox = CType(myGridView.Rows(e.RowIndex).FindControl("txtEditCountryCode"), TextBox)
        '*** Budget ***'
        Dim txtBudget As TextBox = CType(myGridView.Rows(e.RowIndex).FindControl("txtEditBudget"), TextBox)
        '*** Used ***'
        Dim txtUsed As TextBox = CType(myGridView.Rows(e.RowIndex).FindControl("txtEditUsed"), TextBox)

        strSQL = "UPDATE customer SET CustomerID = '" & txtCustomerID.Text & "' " & _
        " ,Name = '" & txtName.Text & "' " & _
        " ,Email = '" & txtEmail.Text & "' " & _
        " ,CountryCode = '" & txtCountryCode.Text & "' " & _
        " ,Budget = '" & txtBudget.Text & "' " & _
        " ,Used = '" & txtUsed.Text & "' " & _
        " WHERE CustomerID = '" & myGridView.DataKeys.Item(e.RowIndex).Value & "'"

		With myDSource			
			.UpdateCommand = strSQL
			.UpdateCommandType = SqlDataSourceCommandType.Text
            .Update()
		End With

        myGridView.EditIndex = -1
        myGridView.ShowFooter = True
        BindData()
	End Sub

</script>
<html>
<head>
    <title>ShotDev.Com Tutorial</title>
</head>
<body>
<form id="form1" runat="server">
<asp:GridView id="myGridView" runat="server" AutoGenerateColumns="False" 
	ShowFooter="True" 
	DataKeyNames="CustomerID"
	OnRowEditing="modEditCommand"
	OnRowCancelingEdit="modCancelCommand"
	OnRowDeleting="modDeleteCommand"
	OnRowUpdating="modUpdateCommand"
	OnRowCommand="myGridView_RowCommand">

	<Columns>

	<asp:TemplateField HeaderText="CustomerID">
		<ItemTemplate>
			<asp:Label id="lblCustomerID" runat="server" Text='<%# DataBinder.Eval(Container, "DataItem.CustomerID") %>'></asp:Label>
		</ItemTemplate>
		<EditItemTemplate>
			<asp:TextBox id="txtEditCustomerID" size="5" runat="server" Text='<%# DataBinder.Eval(Container, "DataItem.CustomerID") %>'></asp:TextBox>
		</EditItemTemplate>
		<FooterTemplate>
			<asp:TextBox id="txtAddCustomerID" size="5" runat="server"></asp:TextBox>
		</FooterTemplate>
	</asp:TemplateField>

	<asp:TemplateField HeaderText="Name">
		<ItemTemplate>
			<asp:Label id="lblName" runat="server" Text='<%# DataBinder.Eval(Container, "DataItem.Name") %>'></asp:Label>
		</ItemTemplate>
		<EditItemTemplate>
			<asp:TextBox id="txtEditName" size="10" runat="server" Text='<%# DataBinder.Eval(Container, "DataItem.Name") %>'></asp:TextBox>
		</EditItemTemplate>
		<FooterTemplate>
			<asp:TextBox id="txtAddName" size="10" runat="server"></asp:TextBox>
		</FooterTemplate>
	</asp:TemplateField>

	<asp:TemplateField HeaderText="Email">
		<ItemTemplate>
			<asp:Label id="lblEmail" runat="server" Text='<%# DataBinder.Eval(Container, "DataItem.Email") %>'></asp:Label>
		</ItemTemplate>
		<EditItemTemplate>
			<asp:TextBox id="txtEditEmail" size="20" runat="server" Text='<%# DataBinder.Eval(Container, "DataItem.Email") %>'></asp:TextBox>
		</EditItemTemplate>
		<FooterTemplate>
			<asp:TextBox id="txtAddEmail" size="20" runat="server"></asp:TextBox>
		</FooterTemplate>
	</asp:TemplateField>

	<asp:TemplateField HeaderText="CountryCode">
		<ItemTemplate>
			<asp:Label id="lblCountryCode" runat="server" Text='<%# DataBinder.Eval(Container, "DataItem.CountryCode") %>'></asp:Label>
		</ItemTemplate>
		<EditItemTemplate>
			<asp:TextBox id="txtEditCountryCode" size="2" runat="server" Text='<%# DataBinder.Eval(Container, "DataItem.CountryCode") %>'></asp:TextBox>
		</EditItemTemplate>
		<FooterTemplate>
			<asp:TextBox id="txtAddCountryCode" size="2" runat="server"></asp:TextBox>
		</FooterTemplate>
	</asp:TemplateField>

	<asp:TemplateField HeaderText="Budget">
		<ItemTemplate>
			<asp:Label id="lblBudget" runat="server" Text='<%# DataBinder.Eval(Container, "DataItem.Budget") %>'></asp:Label>
		</ItemTemplate>
		<EditItemTemplate>
			<asp:TextBox id="txtEditBudget" size="6" runat="server" Text='<%# DataBinder.Eval(Container, "DataItem.Budget") %>'></asp:TextBox>
		</EditItemTemplate>
		<FooterTemplate>
			<asp:TextBox id="txtAddBudget" size="6" runat="server"></asp:TextBox>
		</FooterTemplate>
	</asp:TemplateField>

	<asp:TemplateField HeaderText="Used">
		<ItemTemplate>
			<asp:Label id="lblUsed" runat="server" Text='<%# DataBinder.Eval(Container, "DataItem.Used") %>'></asp:Label>
		</ItemTemplate>
		<EditItemTemplate>
			<asp:TextBox id="txtEditUsed" size="6" runat="server" Text='<%# DataBinder.Eval(Container, "DataItem.Used") %>'></asp:TextBox>
		</EditItemTemplate>
		<FooterTemplate>
			<asp:TextBox id="txtAddUsed" size="6" runat="server"></asp:TextBox>
			<asp:Button id="btnAdd" runat="server" Text="Add" CommandName="Add"></asp:Button>
		</FooterTemplate>
	</asp:TemplateField>

	<asp:CommandField ShowEditButton="True" CancelText="Cancel" DeleteText="Delete" EditText="Edit" UpdateText="Update" HeaderText="Modify"  />
	<asp:CommandField ShowDeleteButton="True" HeaderText="Delete" />
	
	</Columns>
</asp:GridView>
</form>
</body>
</html>
<!--- This file download from www.shotdev.com -->