<%@ Import Namespace="System.Data"%>
<%@ Import Namespace="System.Data.SqlClient"%>
<%@ Page Language="VB" %>

<script runat="server">
	
	Dim clsDB As New clsDatabase
    Sub Page_Load(sender As Object, e As EventArgs)	
        Call myDataReader()
        Call myDataSet()
        Call myDataTable()
        Call myQueryExecuteScalar()
        Call myExecuteNonQuery()
        Call myExecuteTransaction()	
	End Sub


    '*** DataReader ***'
    Sub myDataReader()
        Dim strSQL As String
        Dim dtReader As SqlDataReader
        strSQL = "SELECT * FROM customer "
        dtReader = clsDB.QueryDataReader(strSQL)
        Me.myGridView1.DataSource = dtReader
        Me.myGridView1.DataBind()

        '*** Bind Rows ***'
        'If dtReader.HasRows = True Then
        '    Me.lblCustomerID.Text = dtReader.Item("CustomerID")
        '    Me.lblName.Text = dtReader.Item("Name")
        '    Me.lblEmail.Text = dtReader.Item("Email")
        '    Me.lblCountryCode.Text = dtReader.Item("CountryCode")
        '    Me.lblBudget.Text = dtReader.Item("Budget")
        '    Me.lblUsed.Text = dtReader.Item("Used")
        'End If
        clsDB.Close()
    End Sub

    '*** DataSet ***'
    Sub myDataSet()
        Dim strSQL As String
        Dim ds As DataSet
        strSQL = "SELECT * FROM customer "
        ds = clsDB.QueryDataSet(strSQL)
        Me.myGridView2.DataSource = ds.Tables(0).DefaultView
        Me.myGridView2.DataBind()

        '*** Bind Rows ***'
        'If ds.Tables(0).Rows.Count > 0 Then
        '    Me.lblCustomerID.Text = ds.Tables(0).Rows(0)("CustomerID")
        '    Me.lblName.Text = ds.Tables(0).Rows(0)("Name")
        '    Me.lblEmail.Text = ds.Tables(0).Rows(0)("Email")
        '    Me.lblCountryCode.Text = ds.Tables(0).Rows(0)("CountryCode")
        '    Me.lblBudget.Text = ds.Tables(0).Rows(0)("Budget")
        '    Me.lblUsed.Text = ds.Tables(0).Rows(0)("Used")
        'End If
        clsDB.Close()
    End Sub

    '*** DataTable ***'
    Sub myDataTable()
        Dim strSQL As String
        Dim dt As DataTable
        strSQL = "SELECT * FROM customer "
        dt = clsDB.QueryDataTable(strSQL)
        Me.myGridView3.DataSource = dt
        Me.myGridView3.DataBind()

        '*** Bind Rows ***'
        If dt.Rows.Count > 0 Then
            Me.lblCustomerID.Text = dt.Rows(0)("CustomerID")
            Me.lblName.Text = dt.Rows(0)("Name")
            Me.lblEmail.Text = dt.Rows(0)("Email")
            Me.lblCountryCode.Text = dt.Rows(0)("CountryCode")
            Me.lblBudget.Text = dt.Rows(0)("Budget")
            Me.lblUsed.Text = dt.Rows(0)("Used")
        End If
        clsDB.Close()
    End Sub

    '*** Execute Scalar ***'
    Sub myQueryExecuteScalar()
        Dim strSQL As String
        strSQL = "SELECT MAX(Budget) FROM customer "
        Me.lblText.Text = clsDB.QueryExecuteScalar(strSQL)
        clsDB.Close()
    End Sub

    '*** ExecuteNonQuery ***'
    Sub myExecuteNonQuery()
        Dim strSQL1, strSQL2, strSQL3 As String

        '*** Insert ***'
        strSQL1 = "INSERT INTO customer (CustomerID,Name,Email,CountryCode,Budget,Used) " & _
        " VALUES('C005','Weerachai Nukitram','webmaster@shotdev.com','TH','200000','100000')"
        If clsDB.QueryExecuteNonQuery(strSQL1) = True Then
            '*** Condition Success ***'
        Else
            '*** Condition Error ***'
        End If
        clsDB.Close()

        '*** Update ***'
        strSQL2 = "UPDATE customer SET Budget = '3000000' WHERE CustomerID = 'C005' "
        If clsDB.QueryExecuteNonQuery(strSQL2) = True Then
            '*** Condition Success ***'
        Else
            '*** Condition Error ***'
        End If
        clsDB.Close()

        '*** Delete ***'
        strSQL3 = "DELETE FROM customer WHERE CustomerID = 'C005' "
        If clsDB.QueryExecuteNonQuery(strSQL3) = True Then
            '*** Condition Success ***'
        Else
            '*** Condition Error ***'
        End If
        clsDB.Close()
    End Sub

    '*** Execute Transaction ***'
    Sub myExecuteTransaction()
        Dim strSQL1, strSQL2, strSQL3 As String

        '*** Start Transaction ***'
        clsDB.TransStart()

        Try
            '*** Insert ***'
            strSQL1 = "INSERT INTO customer (CustomerID,Name,Email,CountryCode,Budget,Used) " & _
            " VALUES('C005','Weerachai Nukitram','webmaster@shotdev.com','TH','200000','100000')"
            clsDB.TransExecute(strSQL1) '*** Execute Query 1 ***'

            '*** Update ***'
            strSQL2 = "UPDATE customer SET Budget = '3000000' WHERE CustomerID = 'C005' "
            clsDB.TransExecute(strSQL2) '*** Execute Query 2 ***

            '*** Delete ***'
            strSQL3 = "DELETE FROM customer WHERE CustomerID = 'C005' "
            clsDB.TransExecute(strSQL3) '*** Execute Query 3 ***

            '*** Commit Transaction ***'
            clsDB.TransCommit()

        Catch ex As Exception
            '*** RollBack Transaction ***'
            clsDB.TransRollBack()
        End Try
        clsDB.Close()
    End Sub

</script>
<html>
<head>
    <title>ShotDev.Com Tutorial</title>
</head>
<body>
	<form id="form1" runat="server">
			<asp:GridView id="myGridView1" runat="server"></asp:GridView>
			<br>
			<br>
			<asp:GridView id="myGridView2" runat="server"></asp:GridView><br>
			<br>
			<asp:GridView id="myGridView3" runat="server"></asp:GridView><br>
			<table style="WIDTH: 300px" border="1">
				<tr>
					<td style="WIDTH: 93px">
						<asp:Label id="lblHeaderCustomerID" runat="server" Text="CustomerID"></asp:Label></td>
					<td style="WIDTH: 213px">
						<asp:Label id="lblCustomerID" runat="server"></asp:Label></td>
				</tr>
				<tr>
					<td style="WIDTH: 93px">
						<asp:Label id="lblHeaderName" runat="server" Text="Name"></asp:Label></td>
					<td style="WIDTH: 213px">
						<asp:Label id="lblName" runat="server"></asp:Label></td>
				</tr>
				<tr>
					<td style="WIDTH: 93px">
						<asp:Label id="lblHeaderEmail" runat="server" Text="Email"></asp:Label></td>
					<td style="WIDTH: 213px; HEIGHT: 23px">
						<asp:Label id="lblEmail" runat="server"></asp:Label></td>
				</tr>
				<tr>
					<td style="WIDTH: 93px">
						<asp:Label id="lblHeaderCountryCode" runat="server" Text="CountryCode"></asp:Label></td>
					<td style="WIDTH: 213px; HEIGHT: 23px">
						<asp:Label id="lblCountryCode" runat="server"></asp:Label></td>
				</tr>
				<tr>
					<td style="WIDTH: 93px">
						<asp:Label id="lblHeaderBudget" runat="server" Text="Budget"></asp:Label></td>
					<td style="WIDTH: 213px; HEIGHT: 21px">
						<asp:Label id="lblBudget" runat="server"></asp:Label></td>
				</tr>
				<tr>
					<td style="WIDTH: 93px">
						<asp:Label id="lblHeaderUsed" runat="server" Text="Used"></asp:Label></td>
					<td style="WIDTH: 213px; HEIGHT: 21px">
						<asp:Label id="lblUsed" runat="server"></asp:Label></td>
				</tr>
			</table>
			<br>
			<asp:Label id="lblText" runat="server"></asp:Label>
	</form>
</body>
</html>
<!--- This file download from www.shotdev.com -->