<%@ Import Namespace="System.Data"%>
<%@ Import Namespace="System.Data.OracleClient"%>
<%@ Page Language="VB" %>
<script runat="server">

    Sub Page_Load(sender As Object, e As EventArgs)
		BindData()
    End Sub

	Sub BindData()
		'*** DataSet to DataTable ***'
		myRepeater.DataSource = CreateDsToDt()
		myRepeater.DataBind()	
		
		'*** DataTable ***'
		'myRepeater.DataSource = CreateDataTable()
		'myRepeater.DataBind()		
		
		'*** DataTable (DataTableRows) ***'
		'myRepeater.DataSource = DataTableRows()
		'myRepeater.DataBind()	
		
	End Sub
	
	'*** DataSet to DataTable ***'
	Function CreateDsToDt() As DataTable
        Dim objConn As New System.Data.OracleClient.OracleConnection
		Dim objCmd As New System.Data.OracleClient.OracleCommand
        Dim dtAdapter As New System.Data.OracleClient.OracleDataAdapter
       
		Dim ds As New DataSet
		Dim dt As DataTable
		Dim strConnString,strSQL As String

		strConnString = "Data Source=TCDB;User Id=myuser;Password=mypassword;"
		strSQL = "SELECT * FROM customer"

		objConn.ConnectionString = strConnString
		With objCmd
			.Connection = objConn
			.CommandText = strSQL			
			.CommandType = CommandType.Text
		End With
		dtAdapter.SelectCommand = objCmd

		dtAdapter.Fill(ds)		
		dt = ds.Tables(0)
		
		dtAdapter = Nothing
		objConn.Close()
		objConn = Nothing

		Return dt   '*** Return DataTable ***'

	End Function

	'*** DataTable ***'
	Function CreateDataTable() As DataTable
        Dim objConn As New System.Data.OracleClient.OracleConnection
		Dim dtAdapter As System.Data.OracleClient.OracleDataAdapter 
		Dim dt As New DataTable
       
       
		Dim strConnString As String
		strConnString = "Data Source=TCDB;User Id=myuser;Password=mypassword;"
		objConn = New System.Data.OracleClient.OracleConnection(strConnString)
		objConn.Open()

		Dim strSQL As String		
		strSQL = "SELECT * FROM customer"
		
		dtAdapter = New System.Data.OracleClient.OracleDataAdapter(strSQL, objConn)
		dtAdapter.Fill(dt)

		dtAdapter = Nothing
		objConn.Close()
		objConn = Nothing

		Return dt '*** Return DataTable ***'

	End Function

	'*** TableRows (DataTable) ***'
	Function DataTableRows() As DataTable
        Dim dt As New DataTable
        Dim dr As DataRow
		
		'*** Column ***'
        dt.Columns.Add("CustomerID")
        dt.Columns.Add("Name")
        dt.Columns.Add("Email")
        dt.Columns.Add("CountryCode")
        dt.Columns.Add("Budget")
        dt.Columns.Add("Used")
		
		'*** Rows ***'
		dr = dt.NewRow
        dr("CustomerID") = "C001"
        dr("Name") = "Win Weerachai"
        dr("Email") = "win.weerachai@shotdev.com"
        dr("CountryCode") = "TH"
        dr("Budget") = "1000000"
        dr("Used") = "600000"
        dt.Rows.Add(dr)

		'*** Rows ***'
		dr = dt.NewRow
        dr("CustomerID") = "C002"
        dr("Name") = "Jake Sully"
        dr("Email") = "jake.sully@shotdev.com"
        dr("CountryCode") = "EN"
        dr("Budget") = "2000000"
        dr("Used") = "800000"
        dt.Rows.Add(dr)

		'*** Rows ***'
		dr = dt.NewRow
        dr("CustomerID") = "C003"
        dr("Name") = "Tony Stark"
        dr("Email") = "tony.stark@shotdev.com"
        dr("CountryCode") = "US"
        dr("Budget") = "3000000"
        dr("Used") = "600000"
        dt.Rows.Add(dr)
		
		'*** Rows ***'
		dr = dt.NewRow
        dr("CustomerID") = "C004"
        dr("Name") = "Peter Parker"
        dr("Email") = "peter.parker@shotdev.com"
        dr("CountryCode") = "US"
        dr("Budget") = "4000000"
        dr("Used") = "100000"
        dt.Rows.Add(dr)

		Return dt '*** Return DataTable ***'
	End Function

</script>
<html>
<head>
    <title>ShotDev.Com Tutorial</title>
</head>
<body>
	<form id="form1" runat="server">
    <asp:Repeater id="myRepeater" runat="server">
	<HeaderTemplate>
		<table border="1">
			<tr>
				<th>CustomerID</th>
				<th>Name</th>
				<th>Email</th>
				<th>CountryCode</th>
				<th>Budget</th>
				<th>Used</th>
			</tr>
	</HeaderTemplate>
	<ItemTemplate>
		<tr>
			<td align="center"><%#Container.DataItem("CustomerID") %></td>
			<td><%#Container.DataItem("Name") %></td>
			<td><%#Container.DataItem("Email") %></td>
			<td align="center"><%#Container.DataItem("CountryCode") %></td>
			<td align="right"><%#Container.DataItem("Budget") %></td>
			<td align="right"><%#Container.DataItem("Used") %></td>
		</tr>			
	</ItemTemplate>
	</asp:Repeater>

	</form>
</body>
</html>
<!--- This file download from www.shotdev.com -->